/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.BlockPottedPlant;

public abstract class BlockBNPot
extends BlockBaseNotFull {
    private static final VoxelShape SHAPE = BlockBNPot.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);

    protected BlockBNPot(Block material) {
        super(FabricBlockSettings.m_60926_((BlockBehaviour)material).m_60955_());
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockState plant;
        BlockPos plantPos = pos.m_7494_();
        if (hit.m_82434_() == Direction.UP && world.m_46859_(plantPos) && (plant = BlockPottedPlant.getPlant(player.m_21205_().m_41720_())) != null) {
            if (!world.m_5776_()) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, plantPos, plant);
            }
            world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11839_, SoundSource.BLOCKS, 0.8f, 1.0f, true);
            if (!player.m_7500_()) {
                player.m_21205_().m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public static BlockBNPot from(Block source) {
        return (BlockBNPot)BehaviourHelper.from((Block)source, Wood::new, Stone::new, Metal::new);
    }

    public static class Metal
    extends BlockBNPot
    implements BehaviourMetal {
        public Metal(Block material) {
            super(material);
        }
    }

    public static class Stone
    extends BlockBNPot
    implements BehaviourStone {
        public Stone(Block material) {
            super(material);
        }
    }

    public static class Wood
    extends BlockBNPot
    implements BehaviourWood {
        public Wood(Block material) {
            super(material);
        }
    }
}

